
function PureConfig_set_settings_watcher(pureConfigUI)

    ac.onCSPConfigChanged(ac.CSPModuleID.General, function()
        PURE_CONFIG__get_General_settings()
        pureConfigUI:planDesignReset()
    end)

    ac.onCSPConfigChanged(ac.CSPModuleID.ReflectionsFX, function()
        PURE_CONFIG__get_REFLECTIONS_settings()
        pureConfigUI:planDesignReset()
    end)

    ac.onCSPConfigChanged(ac.CSPModuleID.ParticlesFX, function()
        PURE_CONFIG__get_PARTICLES_settings()
        pureConfigUI:planDesignReset()
    end)

    ac.onCSPConfigChanged(ac.CSPModuleID.GraphicsAdjustments, function()
        PURE_CONFIG__get_CLIPPLANES_settings()
        pureConfigUI:planDesignReset()
    end)

    ac.onCSPConfigChanged(ac.CSPModuleID.WeatherFX, function()
        PURE_CONFIG__get_WFX_settings()
        pureConfigUI:planDesignReset()
    end)

    ac.onCSPConfigChanged(ac.CSPModuleID.Yebisest, function()
        PURE_CONFIG__get_YEBISSEST_settings()
        pureConfigUI:planDesignReset()
    end)

    ac.onCSPConfigChanged(ac.CSPModuleID.SmartShadows, function()
        pureConfigUI:planDesignReset()
    end)
end


function PureConfig_clear_settings_watcher(pureConfigUI)

    ac.onCSPConfigChanged(ac.CSPModuleID.General, function() end)
    ac.onCSPConfigChanged(ac.CSPModuleID.ReflectionsFX, function() end)
    ac.onCSPConfigChanged(ac.CSPModuleID.ParticlesFX, function() end)
    ac.onCSPConfigChanged(ac.CSPModuleID.GraphicsAdjustments, function()
        pureConfigUI:planDesignReset()
    end)
    ac.onCSPConfigChanged(ac.CSPModuleID.WeatherFX, function() end)
    ac.onCSPConfigChanged(ac.CSPModuleID.Yebisest, function() end)

    ac.onCSPConfigChanged(ac.CSPModuleID.SmartShadows, function()
        pureConfigUI:planDesignReset()
    end)
end








local settings = {
    { ac.CSPModuleID.General,               "CONFIGURATIONS",       "WATCH_FOR_CHANGES",            1 },
    { ac.CSPModuleID.General,               "AUDIO",                "DISTANCE_DELAY",               0 },
    { ac.CSPModuleID.WeatherFX,             "PERFORMANCE",          "ADDITIONAL_EFFECTS",           1 },
    { ac.CSPModuleID.ReflectionsFX,         "BASIC",                "ENABLED",                      1 },
    { ac.CSPModuleID.ReflectionsFX,         "MAIN_CUBEMAP",         "USE_PROPER_IBL",               1 },
    { ac.CSPModuleID.ReflectionsFX,         "TWEAKS",               "CUBEMAP_FOR_FOCUSED_CAR",      0 },
    { ac.CSPModuleID.ParticlesFX,           "BASIC",                "ENABLED",                      1 },
    { ac.CSPModuleID.Yebisest,              "BASIC",                "ENABLED",                      1 },
    { ac.CSPModuleID.GraphicsAdjustments,   "BASIC",                "ENABLED",                      1 },
    { ac.CSPModuleID.GraphicsAdjustments,   "ADAPTIVE_CLIP_PLANES", "ENABLED",                      1 },
    --{ ac.CSPModuleID.GraphicsAdjustments,   "ADAPTIVE_CLIP_PLANES", "FAR_PLANE",                  {20000, 30000} },
    { ac.CSPModuleID.GraphicsAdjustments,   "ADAPTIVE_CLIP_PLANES", "NEAR_PLANE",                   {0.1, 10} },
}

function PureConfig_Fix_Wrong_Settings(pureConfigUI, connect)
    
    PureConfig_clear_settings_watcher(pureConfigUI)

    local modul = ac.INIConfig.cspModule(settings[1][1])
    modul:setAndSave(settings[1][2], settings[1][3], 0)

    for i=2, #settings do
        modul = ac.INIConfig.cspModule(settings[i][1])
        if modul then
            modul:set(settings[i][2], settings[i][3], settings[i][4])
            modul:save()
        end
    end

    modul = ac.INIConfig.cspModule(ac.CSPModuleID.GraphicsAdjustments)
    local farplanes = modul:get("ADAPTIVE_CLIP_PLANES", "FAR_PLANE", {"20000", "30000"})
    if farplanes~=nil then
        if farplanes[1]~=nil then
            local tmp = math.min(140000, tonumber(farplanes[1]))
            farplanes = { tmp, tmp+10000 }
            modul:set("ADAPTIVE_CLIP_PLANES", "FAR_PLANE", farplanes)
            modul:save()
        end
    end
--[[
    if modul:get("ANTIALIASING","MODE","") == "FXAA3" then
        modul:set("ANTIALIASING", "MODE", "DISABLED")
        modul:save()
    end
]]
    modul = ac.INIConfig.cspModule(settings[1][1])
    modul:setAndSave(settings[1][2], settings[1][3], 1)

    if PURE_CONFIG__initialize__CSP_SETTINGS_CHECK then
        PURE_CONFIG__initialize__CSP_SETTINGS_CHECK()
        pureConfigUI:planDesignReset()
        connect:addCommand("resetPure")
    end
end